<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReadableLog extends Model 
{

    protected $table = 'readable_logs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('related', 'name_ar', 'name_en', 'content_ar', 'content_en', 'causer');

    public function causer()
    {
        return $this->morphTo();
    }

    public function related()
    {
        return $this->morphTo();
    }

}